// GLOBALE VARIABLE



// BEIM LADEN DES POPUPS
document.addEventListener('DOMContentLoaded', function(event) {
	// Verlinke Popup-Elemente  
	document.getElementsByName('UI#popup#btn#unterseite').forEach(function(el) {
		el.onclick = function(event) {handler.unterseite(event,event.target.getAttribute('wert'));};
	});

	// Fülle Checkboxesbereich aus:
	var td = document.getElementById('HauptUI#trennlinie');
	affattribute.forEach(function(attr) {
		var btn = document.createElement('input');
		var span = document.createElement('span');
		var br = document.createElement('br');
		td.parentNode.insertBefore(btn,td);
		td.parentNode.insertBefore(span,td);
		td.parentNode.insertBefore(br,td);
		btn.id = 'HauptUI#checkbox#spalte#'+attr.tag;
		btn.type = 'checkbox';
		btn.checked = false; // <-- wird gleich initialisiert
		span.style.fontSize = 'x-small';
		span.textContent = attr.titel;
	});

	// Führe einmalig aus:
	window.addEventListener('DOMContentLoaded', function() {
		chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
			chrome.tabs.sendMessage(tabs[0].id,{from:'popup.js', to:'content.js', subject:'AFF#checkbox#auswahlmodus#status'}, response.launch.auswahlmodus);
			chrome.tabs.sendMessage(tabs[0].id,{from:'popup.js', to:'content.js', subject:'AFF#daten'}, response.launch.aff);
			chrome.tabs.sendMessage(tabs[0].id,{from:'popup.js', to:'content.js', subject:'AFF#checkbox#spalten#status'}, response.checkbox.spalten);
		});
	});

	// Füge Listeners hinzu:
	document.getElementById('HauptUI#button#kopieren').addEventListener('click',handler.button.kopieren);
	document.getElementById('HauptUI#checkbox#auswahlmodus').addEventListener('click',handler.checkbox.auswahlmodus);
	affattribute.forEach(function(attr) {
		var key = attr.tag;
		var btn = document.getElementById('HauptUI#checkbox#spalte#'+key);
		btn.addEventListener('click',handler.checkbox.spalten(key));
	});

	// Lausche nach Messages von background.js:
	chrome.runtime.onMessage.addListener(function (msg, sender, response) {
		if (msg.from === 'background.js' && msg.to === 'popup.js' && msg.subject === '#Tastebefehl#herv') {
			handler.checkbox.gesamt();
		} else if (msg.from === 'background.js' && msg.to === 'popup.js' && msg.subject === '#Tastebefehl#kopieren') {
			handler.button.kopieren();
		}
	});

	// Fokus auf Kopieren-Knopf setzen:
	document.getElementById('HauptUI#button#kopieren').focus();
});


// EVENT HANDLER
var handler = {
	'unterseite': function(event,url) {
		if(event.metaKey || event.ctrlKey) {
			var target = '_blank';
		} else {
			var target = '_self';
		}
		response.unterseite(url,target);
	},
	button: {
		kopieren: function() {
			response.button.kopieren();
		},
	},
	checkbox: {
		auswahlmodus: function() {
			var auswahlmodus = document.getElementById('HauptUI#checkbox#auswahlmodus').checked;
			chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
				chrome.tabs.sendMessage(tabs[0].id,{from:'popup.js', to:'content.js', subject:'AFF#checkbox#auswahlmodus', auswahlmodus:auswahlmodus});
			});
		},
		spalten: function(key) {
			return function() {
			chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
				chrome.tabs.sendMessage(tabs[0].id, {from:'popup.js', to:'content.js', subject:'AFF#checkbox#spalten', spalte:key}, response.checkbox.spalten);
			});
			// Kopieren-Knopf auf Nullzustand versetzen.
			document.getElementById('HauptUI#button#kopieren').value = affTblKopiert.ja;
			response.button.kopieren();
			}
		},
		einzel: function(index) {
			return function() {
			var checked = this.checked;
			chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
				chrome.tabs.sendMessage(tabs[0].id, {from:'popup.js', to:'content.js', subject:'AFF#checkbox#herv#einzel', index:index, checked:checked},response.checkbox.herv);
			});
			//response.checkbox.einzel(this,index);
			};
		},
		segment: function(index) {
			return function () {
				var checked = this.checked;
				chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
				chrome.tabs.sendMessage(tabs[0].id, {from:'popup.js', to:'content.js', subject:'AFF#checkbox#herv#segment', index:index, checked:checked},response.checkbox.herv);
				});
				//response.checkbox.segment(this,index);
			};
		},  
		gesamt: function() {
			chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
				chrome.tabs.sendMessage(tabs[0].id,{from:'popup.js', to:'content.js', subject:'AFF#checkbox#herv#gesamt'},response.checkbox.herv);
			});
			//response.checkbox.gesamt(this);
		},
	},
};


// RESPONSE-FUNKTIONEN
var response = {
	'unterseite': function(url,target) {
		chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
			chrome.tabs.sendMessage(tabs[0].id, {from:'popup.js', to:'content.js', subject:'öffne URL!', url:url, target:target});
		});
	},
	launch: {
		auswahlmodus: function(checked) {
			document.getElementById('HauptUI#checkbox#auswahlmodus').checked = checked;
		},
		aff: function(ergebnis) {
			if(ergebnis.found) {
			// Checkbox+Knopfbereich zeigen:
			document.getElementById('HauptUI').style.display = '';
			
			// Knopf zum Auswahlmodus bereistellen:
			document.getElementById('HauptUI#checkbox#auswahlmodus').checked = ergebnis.auswahlmodus;

			// Knopf zum Kopieren von Daten bereitstellen:
			var btn = document.getElementById('HauptUI#button#kopieren');
			btn.value = affTblKopiert.nein;

			// Datentabelle kreieren (inkl. Bereistellung von Hervorhebung-Checkboxes)
			var div = document.getElementById('div#AFF-Links');
			var tbl = FKT_afflinks.tabelle(ergebnis,'popup.js');
			tbl.align = 'right';
			div.verticalAlign = 'top';
			tbl.id = 'div#AFF-Links#tabelle';
			div.appendChild(tbl);

			// Meldung verbergen:
			document.getElementById('div#AFF-Links#Meldung').style.display = 'none';

			// Fokus auf den Kopieren-Knopf setzen:
			// (muss als aller Letztes durchgeführt werden)
			btn.focus();
			} else {
			// Checkbox+Knopfbereich verbergen:
			document.getElementById('HauptUI').style.display = 'none';
			document.getElementById('PopupLogo').colSpan = 2;
			// Meldung anzeigen:
			document.getElementById('div#AFF-Links#Meldung#Text').textContent = 'Keine AFF-Links aufgespürt.';
			document.getElementById('div#AFF-Links#Meldung').style.display = 'block';
			// Fokus auf das Logo setzen:
			document.getElementById('PopupLogo#url').focus();
			}
		},
	},
	button: {
		kopieren: function() {
			var btn = document.getElementById('HauptUI#button#kopieren');
			var wert = btn.value;
			if(wert === affTblKopiert.nein) {
			tc = document.getElementsByClassName('#tabelle#spalte#'+'checkbox');
			for(var i=0; i<tc.length; i++) {
				tc[i].style.display = 'none';
			}
			tbl = document.getElementById('div#AFF-Links#tabelle');
			var output = {
				erfolg: function() {
					document.getElementById('HauptUI#button#kopieren').value = affTblKopiert.ja;
				},
				misserfolg: function() {
					document.getElementById('Button#kopieren#feedback').textContent = affTblKopiert.fehler;
				},
				fehler: function() {
					alert('Nicht unterstützt vom Browser!');
				},
			};
			if(FKT_kopieren.bereitstellen(tbl,output)) {
				wert = affTblKopiert.ja;
			}
			for(var i=0; i<tc.length; i++) {
				tc[i].style.display = '';
			}
			btn.value = wert;
			} else {
			btn.value = affTblKopiert.nein;
			}
			btn.focus();
		},
	},
	checkbox: {
		herv: function(ergebnis) {
			var herv = ergebnis.herv;
			// Aktualisierte Gesamt-Knopf
			var tagGES = '#tabelle#checkbox#[]';
			var btnGES = document.getElementById(tagGES);
			if(btnGES) {btnGES.checked = ergebnis.herv};
			ergebnis.affdaten.forEach(function(elementAFF,seg) {
			// Aktualisierte Segment-Knopf
			var tagSEG = '#tabelle#checkbox#['+seg+']';
			var btnSEG = document.getElementById(tagSEG);
			if(btnSEG) {btnSEG.checked = elementAFF.herv};
			elementAFF.checkbox.forEach(function(bool,zeile) {
				// Aktualisierte Zeile-Knopf
				var tagZEILE = '#tabelle#checkbox#['+seg+','+zeile+']';
				var btnZEILE = document.getElementById(tagZEILE);
				if(btnZEILE) {btnZEILE.checked = bool};
			});
			});
		},
		/*
		einzel: function(self,index) {
			var auswahlmodus = document.getElementById('HauptUI#checkbox#auswahlmodus').checked;
			var checked = self.checked;
			if(!auswahlmodus && checked) {
			var checkbox = document.getElementsByClassName('#tabelle#checkbox#einzel');
			for(var i=0; i<checkbox.length; i++) {
				checkbox[i].checked = false;
			};
			self.checked = true;
			// Wenn ein Segment nur eine Checkbox hat, so hat dieses Segment
			// keine Überschrift mit Checkbox: deshalb muss diese hier 
			// NICHT evtl. aktualisiert werden.
			}
		},
		segment: function(self,index) {
			var auswahlmodus = document.getElementById('HauptUI#checkbox#auswahlmodus').checked;
			var checked = self.checked;
			if (checked) {
			if(!auswahlmodus) {
				var checkbox = document.getElementsByClassName('#tabelle#checkbox#einzel');
				for(var i=0; i<checkbox.length; i++) {
				checkbox[i].checked = false;
				}
			}
			var checkbox = document.getElementsByClassName('#tabelle#checkbox#segment#'+index);
			for(var i=0; i<checkbox.length; i++) {
				checkbox[i].checked = true;
			}
			} else {
			var checkbox = document.getElementsByClassName('#tabelle#checkbox#segment#'+index);
			for(var i=0; i<checkbox.length; i++) {
				checkbox[i].checked = false;
			}
			}
		},
		gesamt: function(self) {
			var herv = self.herv;
			var checkbox = document.getElementsByClassName('#tabelle#checkbox');
			for(var i = 0; i<checkbox.length; i++) {
			checkbox[i].checked = herv;
			}
		},
		*/
		spalten: function(togglewerte) {
			affattribute.forEach(function(attr) {
			var key = attr.tag;
			var tc = document.getElementsByClassName('#tabelle#spalte#'+key);
			var btn = document.getElementById('HauptUI#checkbox#spalte#'+key);
			if(togglewerte[key]) {
				btn.checked = true;
				for(var i=0; i<tc.length; i++) {
				tc[i].style.display = '';
				}
			} else {
				btn.checked = false;
				for(var i=0; i<tc.length; i++) {
				tc[i].style.display = 'none';
				}
			}
			});
			var nCol = togglewerte.countUp(lambdaID);
			// Aktualisiere Spaltenbreite von Segmentenüberschriften
			var tdSEG = document.getElementsByClassName('#tabelle#segment#ueberschrift');
			for(var i=0; i<tdSEG.length; i++) {
			tdSEG[i].colSpan = nCol;
			}
		},
	},
}